/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.util.HashSet;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.tritonus.share.sampled.convert.TFormatConversionProvider;

public class SmartFormatConversionProvider
extends TFormatConversionProvider {
    private Set m_blockedThreads = new HashSet();

    public AudioFormat.Encoding[] getSourceEncodings() {
        return EMPTY_ENCODING_ARRAY;
    }

    public AudioFormat.Encoding[] getTargetEncodings() {
        return EMPTY_ENCODING_ARRAY;
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        return null;
    }

    public boolean isConversionSupported(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        return false;
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        return null;
    }

    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        if (this.isCurrentThreadBlocked()) {
            return false;
        }
        AudioFormat[] aIntermediateFormats = this.getIntermediateFormats(sourceFormat, targetFormat);
        return aIntermediateFormats != null;
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream audioInputStream) {
        return null;
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream audioInputStream) {
        return null;
    }

    private AudioFormat[] getIntermediateFormats(AudioFormat sourceFormat, AudioFormat targetFormat) {
        AudioFormat.Encoding sourceEncoding = sourceFormat.getEncoding();
        AudioFormat.Encoding targetEncoding = targetFormat.getEncoding();
        this.blockCurrentThread();
        boolean bDirectConversionPossible = AudioSystem.isConversionSupported(targetFormat, sourceFormat);
        this.unblockCurrentThread();
        if (bDirectConversionPossible) {
            return EMPTY_FORMAT_ARRAY;
        }
        if (SmartFormatConversionProvider.isPCM(sourceEncoding) && SmartFormatConversionProvider.isPCM(targetEncoding)) {
            return null;
        }
        if (!SmartFormatConversionProvider.isPCM(sourceEncoding)) {
            AudioFormat intermediateFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), -1, sourceFormat.getSampleRate(), true);
            this.blockCurrentThread();
            AudioFormat[] aPreIntermediateFormats = this.getIntermediateFormats(sourceFormat, intermediateFormat);
            this.unblockCurrentThread();
            AudioFormat[] aPostIntermediateFormats = this.getIntermediateFormats(intermediateFormat, targetFormat);
            if (aPreIntermediateFormats != null && aPostIntermediateFormats != null) {
                AudioFormat[] aIntermediateFormats = new AudioFormat[aPreIntermediateFormats.length + 1 + aPostIntermediateFormats.length];
                System.arraycopy(aPreIntermediateFormats, 0, aIntermediateFormats, 0, aPreIntermediateFormats.length);
                aIntermediateFormats[aPreIntermediateFormats.length] = intermediateFormat;
                System.arraycopy(aPostIntermediateFormats, 0, aIntermediateFormats, aPreIntermediateFormats.length, aPostIntermediateFormats.length);
                return aIntermediateFormats;
            }
            return null;
        }
        if (!SmartFormatConversionProvider.isPCM(targetEncoding)) {
            AudioFormat intermediateFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, targetFormat.getSampleRate(), targetFormat.getSampleSizeInBits(), targetFormat.getChannels(), -1, targetFormat.getSampleRate(), true);
            AudioFormat[] aPreIntermediateFormats = this.getIntermediateFormats(sourceFormat, intermediateFormat);
            this.blockCurrentThread();
            AudioFormat[] aPostIntermediateFormats = this.getIntermediateFormats(intermediateFormat, targetFormat);
            this.unblockCurrentThread();
            if (aPreIntermediateFormats != null && aPostIntermediateFormats != null) {
                AudioFormat[] aIntermediateFormats = new AudioFormat[aPreIntermediateFormats.length + 1 + aPostIntermediateFormats.length];
                System.arraycopy(aPreIntermediateFormats, 0, aIntermediateFormats, 0, aPreIntermediateFormats.length);
                aIntermediateFormats[aPreIntermediateFormats.length] = intermediateFormat;
                System.arraycopy(aPostIntermediateFormats, 0, aIntermediateFormats, aPreIntermediateFormats.length, aPostIntermediateFormats.length);
                return aIntermediateFormats;
            }
            return null;
        }
        return null;
    }

    private static boolean isPCM(AudioFormat.Encoding encoding) {
        return encoding.equals(AudioFormat.Encoding.PCM_SIGNED) || encoding.equals(AudioFormat.Encoding.PCM_SIGNED);
    }

    private static boolean isSignedPCM(AudioFormat.Encoding encoding) {
        return encoding.equals(AudioFormat.Encoding.PCM_SIGNED);
    }

    private boolean isCurrentThreadBlocked() {
        return this.m_blockedThreads.contains(Thread.currentThread());
    }

    private void blockCurrentThread() {
        this.m_blockedThreads.add(Thread.currentThread());
    }

    private void unblockCurrentThread() {
        this.m_blockedThreads.remove(Thread.currentThread());
    }
}

