/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.sampled.file.WaveTool;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class WaveAudioFileReader
extends TAudioFileReader {
    private static final int READ_LIMIT = 1000;

    public WaveAudioFileReader() {
        super(1000);
    }

    protected void advanceChunk(DataInputStream dis, long prevLength, long prevRead) throws IOException {
        if (prevLength > 0L) {
            dis.skip((prevLength + 1L & 0xFFFFFFFFFFFFFFFEL) - prevRead);
        }
    }

    protected long findChunk(DataInputStream dis, int key) throws UnsupportedAudioFileException, IOException {
        int thisKey;
        long chunkLength = 0L;
        do {
            this.advanceChunk(dis, chunkLength, 0L);
            try {
                thisKey = dis.readInt();
            }
            catch (IOException e) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out((Throwable)e);
                }
                throw new UnsupportedAudioFileException("unsupported WAVE file: required chunk not found.");
            }
            chunkLength = WaveAudioFileReader.readLittleEndianInt((InputStream)dis) & 0xFFFFFFFF;
        } while (thisKey != key);
        return chunkLength;
    }

    /*
     * WARNING - void declaration
     */
    protected AudioFormat readFormatChunk(DataInputStream dis, long chunkLength) throws UnsupportedAudioFileException, IOException {
        void var11_14;
        void var12_13;
        String debugAdd = "";
        int read = 14;
        if (chunkLength < 14L) {
            throw new UnsupportedAudioFileException("corrupt WAVE file: format chunk is too small");
        }
        short formatCode = WaveAudioFileReader.readLittleEndianShort((InputStream)dis);
        short channelCount = WaveAudioFileReader.readLittleEndianShort((InputStream)dis);
        if (channelCount <= 0) {
            throw new UnsupportedAudioFileException("corrupt WAVE file: number of channels must be positive");
        }
        int sampleRate = WaveAudioFileReader.readLittleEndianInt((InputStream)dis);
        if (sampleRate <= 0) {
            throw new UnsupportedAudioFileException("corrupt WAVE file: sample rate must be positive");
        }
        int avgBytesPerSecond = WaveAudioFileReader.readLittleEndianInt((InputStream)dis);
        short blockAlign = WaveAudioFileReader.readLittleEndianShort((InputStream)dis);
        int frameSize = 0;
        float frameRate = sampleRate;
        short cbSize = 0;
        switch (formatCode) {
            case 1: {
                AudioFormat.Encoding encoding;
                if (chunkLength < 16L) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: format chunk is too small");
                }
                int sampleSizeInBits = WaveAudioFileReader.readLittleEndianShort((InputStream)dis);
                if (sampleSizeInBits <= 0) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: sample size must be positive");
                }
                AudioFormat.Encoding encoding2 = encoding = sampleSizeInBits <= 8 ? AudioFormat.Encoding.PCM_UNSIGNED : AudioFormat.Encoding.PCM_SIGNED;
                if (TDebug.TraceAudioFileReader) {
                    debugAdd = debugAdd + ", wBitsPerSample=" + sampleSizeInBits;
                }
                read += 2;
                break;
            }
            case 6: {
                int sampleSizeInBits = 8;
                AudioFormat.Encoding encoding = AudioFormat.Encoding.ALAW;
                break;
            }
            case 7: {
                int sampleSizeInBits = 8;
                AudioFormat.Encoding encoding = AudioFormat.Encoding.ULAW;
                break;
            }
            case 49: {
                if (chunkLength < 20L) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: extra GSM bytes are missing");
                }
                int sampleSizeInBits = WaveAudioFileReader.readLittleEndianShort((InputStream)dis);
                cbSize = WaveAudioFileReader.readLittleEndianShort((InputStream)dis);
                if (cbSize < 2) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: extra GSM bytes are corrupt");
                }
                int decodedSamplesPerBlock = WaveAudioFileReader.readLittleEndianShort((InputStream)dis) & 0xFFFF;
                if (TDebug.TraceAudioFileReader) {
                    debugAdd = debugAdd + ", wBitsPerSample=" + sampleSizeInBits + ", cbSize=" + cbSize + ", wSamplesPerBlock=" + decodedSamplesPerBlock;
                }
                sampleSizeInBits = -1;
                AudioFormat.Encoding encoding = WaveTool.GSM0610;
                frameSize = blockAlign;
                frameRate = (float)sampleRate / (float)decodedSamplesPerBlock;
                read += 6;
                break;
            }
            case 17: {
                if (chunkLength < 16L) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: extra GSM bytes are missing");
                }
                int sampleSizeInBits = WaveAudioFileReader.readLittleEndianShort((InputStream)dis);
                cbSize = WaveAudioFileReader.readLittleEndianShort((InputStream)dis);
                if (cbSize < 2) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: extra IMA ADPCM bytes are corrupt");
                }
                int samplesPerBlock = WaveAudioFileReader.readLittleEndianShort((InputStream)dis) & 0xFFFF;
                if (TDebug.TraceAudioFileReader) {
                    debugAdd = debugAdd + ", wBitsPerSample=" + sampleSizeInBits + ", cbSize=" + cbSize + ", wSamplesPerBlock=" + samplesPerBlock;
                }
                sampleSizeInBits = -1;
                AudioFormat.Encoding encoding = WaveTool.GSM0610;
                frameSize = blockAlign;
                frameRate = (float)sampleRate / (float)samplesPerBlock;
                read += 6;
                break;
            }
            default: {
                throw new UnsupportedAudioFileException("unsupported WAVE file: unknown format code " + formatCode);
            }
        }
        if (frameSize == 0) {
            frameSize = WaveAudioFileReader.calculateFrameSize((int)var12_13, (int)channelCount);
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"WaveAudioFileReader.readFormatChunk():");
            TDebug.out((String)("  read values: wFormatTag=" + formatCode + ", nChannels=" + channelCount + ", nSamplesPerSec=" + sampleRate + ", nAvgBytesPerSec=" + avgBytesPerSecond + ", nBlockAlign==" + blockAlign + debugAdd));
            TDebug.out((String)("  constructed values: encoding=" + var11_14 + ", sampleRate=" + (float)sampleRate + ", sampleSizeInBits=" + (int)var12_13 + ", channels=" + channelCount + ", frameSize=" + frameSize + ", frameRate=" + frameRate));
        }
        this.advanceChunk(dis, chunkLength, read);
        return new AudioFormat((AudioFormat.Encoding)var11_14, sampleRate, (int)var12_13, channelCount, frameSize, frameRate, false);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long lFileLengthInBytes) throws UnsupportedAudioFileException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int magic = dataInputStream.readInt();
        if (magic != 1380533830) {
            throw new UnsupportedAudioFileException("not a WAVE file: wrong header magic");
        }
        long totalLength = WaveAudioFileReader.readLittleEndianInt((InputStream)dataInputStream) & 0xFFFFFFFF;
        magic = dataInputStream.readInt();
        if (magic != 1463899717) {
            throw new UnsupportedAudioFileException("not a WAVE file: wrong header magic");
        }
        long chunkLength = this.findChunk(dataInputStream, 1718449184);
        AudioFormat format = this.readFormatChunk(dataInputStream, chunkLength);
        long dataChunkLength = this.findChunk(dataInputStream, 1684108385);
        long frameLength = dataChunkLength / (long)format.getFrameSize();
        if (format.getEncoding().equals(WaveTool.GSM0610)) {
            frameLength = dataChunkLength;
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)("WaveAudioFileReader.getAudioFileFormat(): total length: " + totalLength + ", frame length = " + frameLength));
        }
        return new TAudioFileFormat(AudioFileFormat.Type.WAVE, format, (int)frameLength, (int)(totalLength + 8L));
    }
}

